/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.jruby.Ruby;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.URLUtil;

public class ClasspathLauncher {
    public static String jrubyCommand(ClassLoader classLoader) {
        String javaHome = SafePropertyAccessor.getProperty("java.home", "");
        String javaCmd = javaHome + "/bin/java";
        if (!new File(javaCmd).exists()) {
            javaCmd = javaHome + "/jre/bin/java";
        }
        if (!new File(javaCmd).exists()) {
            javaCmd = "java";
        }
        StringBuilder command = new StringBuilder(javaCmd + " -cp ");
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                String path2 = URLUtil.getPlatformPath(url);
                if (path2 == null) continue;
                command.append(File.pathSeparatorChar).append(path2);
            }
        } else {
            command.append(File.pathSeparatorChar).append(SafePropertyAccessor.getProperty("java.class.path"));
        }
        command.append(" org.jruby.Main");
        return command.toString();
    }

    public static String jrubyCommand(Ruby runtime) {
        return ClasspathLauncher.jrubyCommand(runtime.getJRubyClassLoader().getParent());
    }
}

